package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
public class FlightRecordListRequestParam {

    @ApiModelProperty("航班记录编号")
    private String flightRecordNo;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime departureDateStart;

    @ApiModelProperty("时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime departureDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
