package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.OrderBO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/order")
@Api("订单管理")
public interface OrderFeign {


  @ApiOperation(value = "新增订单", notes = "新增订单", tags = {"新增订单接口"},httpMethod = "POST")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<Boolean> add(@RequestBody(required = false) OrderBO orderBO);

}
