package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrMemberFrozenRequestParam;
import com.bizvane.members.feign.model.bo.MbrMemberUpdateRequestParam;
import com.bizvane.members.feign.model.bo.MbrOpenCardRequestParam;
import com.bizvane.members.feign.model.vo.MbrMembersVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/member")
@Api("会员管理")
public interface MbrMemberFeign {

    @ApiOperation(value = "通过手机号查询会员")
    @RequestMapping(value="/getMemberByPhone", method = RequestMethod.POST)
    MbrMembersVO getMemberByPhone(@Param("phone") String phone);

    @ApiOperation(value = "开卡")
    @RequestMapping(value="/openCard", method = RequestMethod.POST)
    ResponseData<Boolean>  openCard(@RequestBody MbrOpenCardRequestParam param);

    @ApiOperation(value = "更新会员资料")
    @RequestMapping(value="/update", method = RequestMethod.POST)
    ResponseData<Boolean> update(@RequestBody MbrMemberUpdateRequestParam updateRequestParam);

    @ApiOperation(value = "会员冻结/解冻接口")
    @RequestMapping(value="/frozenOrUnFrozen", method = RequestMethod.POST)
    ResponseData<Boolean> frozenOrUnFrozen(@RequestBody MbrMemberFrozenRequestParam param);
}
