package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.CouponDefinitionListRequestParam;
import com.bizvane.members.feign.model.bo.CouponDefinitionAddRequestParam;
import com.bizvane.members.feign.model.bo.CouponDefinitionUpdateStatusRequestParam;
import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/couponDef")
@Api("券定义管理")
public interface CouponDefFeign {

  @ApiOperation(value = "发券")
  @RequestMapping(value="/addDef", method = RequestMethod.POST)
  ResponseData<Boolean> add(@RequestBody CouponDefinitionAddRequestParam param);

  PageInfo<CouponDefinitionVO> list(@RequestBody CouponDefinitionListRequestParam param);

  CouponDefinitionVO detail(@Param("mbrBenefitsCode")String couponDefinitionCode);

  ResponseData<Boolean> updateStatus(@RequestBody CouponDefinitionUpdateStatusRequestParam param);
}