package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class MbrMemberUpdateByPhoneRequest {

    @ApiModelProperty("phone")
    private String phone;

    @ApiModelProperty("微信unioinid")
    private String unionId;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("会员性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("会员头像")
    private String headPortraits;

    @ApiModelProperty("会员邮箱")
    private String email;

    @ApiModelProperty("会员生日")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime birthday;

    @ApiModelProperty("会员省份")
    private String province;

    @ApiModelProperty("会员市区")
    private String city;

    @ApiModelProperty("会员县")
    private String county;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("修改人code")
    private String userCode;

    @ApiModelProperty("修改人")
    private String userName;

    @ApiModelProperty("会员类型：0-普通会员，1-内部员工、2-委外员工、3-驻场外部员工、 4-外包员工、5-浦东O2O认证工作人员")
    private Integer type;

    @ApiModelProperty(value = "手机号集合")
    private List<String> phoneList;

}
