package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponDefinitionListRequestParam {

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券编号集合")
    private List<String> couponDefinitionCodeList;

    @ApiModelProperty("券状态（1已启用，0已停用）")
    private Boolean status;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券属性")
    private String couponType;

    @ApiModelProperty("券生成渠道：1-crm生成，2-外部系统")
    private Integer generationChannel;

    @ApiModelProperty("创建人")
    private String userName;

    @ApiModelProperty("创建时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateStart;

    @ApiModelProperty("创建时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateEnd;

    private List<String> orgCodeList;

    private int pageNum = 1;

    private int pageSize  = 10;

    @ApiModelProperty("标识 添加积分兑换券展示优惠券列表时set为true")
    private Boolean sign;

}
