package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Created by Administrator on 2018\8\10 0010.
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MiniProgramOpenCardService {

    @RequestMapping(value = "/api/openCard", method = RequestMethod.POST)
    ResponseOpenCardModel openCard(@RequestBody RequestOpenCardModel responseOpenCardModel);

    @RequestMapping(value = "/api/openCardV", method = RequestMethod.POST)
    ResponseData<ResponseOpenCardModel> openCardV(@RequestBody RequestOpenCardModel requestOpenCardModel);
}
