package com.bizvane.members.facade.enums.yw;

import lombok.Getter;

/**
 * 性别枚举
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年09月17日 13:49:00
 */
@Getter
public enum YWGenderEnum {
    FAMALE("1", 2,0 ,"女"),
    MALE("2",1,1,"男"),
    UNKNOWN_SEX("3",0,-1 ,"未知");

    private String bizSex;

    private Integer yzSex;

    private Integer nxSex;

    private String msg;

    YWGenderEnum(String bizSex, Integer yzSex, Integer nxSex, String msg) {
        this.bizSex = bizSex;
        this.yzSex = yzSex;
        this.nxSex = nxSex;
        this.msg = msg;
    }
    public static String getStrGenderByYZ(Integer yzSex){
        for (YWGenderEnum genderEnum : YWGenderEnum.values()) {
            if (yzSex.equals(genderEnum.getYzSex())) {
                return genderEnum.getMsg();
            }
        }
        return UNKNOWN_SEX.getMsg();
    }
    public static String getBizGender(Integer yzSex) {
        for (YWGenderEnum genderEnum : YWGenderEnum.values()) {
            if (yzSex.equals(genderEnum.getYzSex())) {
                return genderEnum.getBizSex();
            }
        }
        return UNKNOWN_SEX.getBizSex();
    }
    //通过南讯性别获取商帆性别
    public static String getBizGenderFromNx(Integer nxSex) {
        for (YWGenderEnum genderEnum : YWGenderEnum.values()) {
            if (nxSex.equals(genderEnum.getNxSex())) {
                return genderEnum.getBizSex();
            }
        }
        return UNKNOWN_SEX.getBizSex();
    }
    //通过南讯性别获取有赞性别
    public static Integer getYouZanGenderFromNx(Integer nxSex) {
        for (YWGenderEnum genderEnum : YWGenderEnum.values()) {
            if (nxSex.equals(genderEnum.getNxSex())) {
                return genderEnum.getYzSex();
            }
        }
        return UNKNOWN_SEX.getYzSex();
    }
    //通过有赞获取南讯性别
    public static Integer getNxGenderFromYouZan(Integer yzSex) {
        for (YWGenderEnum genderEnum : YWGenderEnum.values()) {
            if (yzSex.equals(genderEnum.getYzSex())) {
                return genderEnum.getYzSex();
            }
        }
        return UNKNOWN_SEX.getYzSex();
    }

    //通过商帆性别获取有赞性别
    public static Integer getThirdGender(Integer bizSex) {
        for (YWGenderEnum genderEnum : YWGenderEnum.values()) {
            if (bizSex.equals(Integer.valueOf(genderEnum.getBizSex()))) {
                return genderEnum.getYzSex();
            }
        }
        return UNKNOWN_SEX.getYzSex();
    }
    public static Integer getNXGender(Integer bizSex) {
        for (YWGenderEnum genderEnum : YWGenderEnum.values()) {
            if (bizSex.equals(Integer.valueOf(genderEnum.getBizSex()))) {
                return genderEnum.getNxSex();
            }
        }
        return UNKNOWN_SEX.getNxSex();
    }

}
