package com.bizvane.members.facade.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MemberLabelUpdateReq {

    private Long sysCompanyId;

    private Long sysBrandId;

    @NotEmpty
    private String brandCode;

    @NotEmpty
    private String erpId;

    private List<Label> labelList;

    // 操作类型：add添加，del删除
    private String action;

    @Data
    public static class Label {
        private String labelCode;
        private List<String> valueList;;
    }
}
