package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 商秀、中台 会员标签操作记录
 */
@Data
@NoArgsConstructor

public class MbrLabelRecordModel {
    private static final long serialVersionUID = 1830132372661671599L;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "归属品牌", name = "brandId", example = "归属品牌")
    private Long brandId;

    @ApiModelProperty(value = "会员code", name = "memberCode", example = "会员code")
    private String memberCode;

    @ApiModelProperty(value = "标签类型code", name = "labelCode", example = "标签类型code")
    private String labelCode;

    @ApiModelProperty(value = "标签类型名称", name = "labelName", example = "标签类型名称")
    private String labelName;

    @ApiModelProperty(value = "导购code", name = "guideCode", example = "导购code")
    private String guideCode;

    @ApiModelProperty(value = "标签操作来源：1=中台；2=企业微信", name = "labelRecordType", example = "标签操作来源：1=中台；2=企业微信")
    private Integer labelRecordType;

    @ApiModelProperty(value = "修改时间", name = "labelRecordTime", example = "标签操作来源：1=中台；2=企业微信")
    private Date labelRecordTime;

    @ApiModelProperty(value = "操作标签类型", name = "operateLabelType", example = "标签操作来源：1帖标签 2撕标签")
    private Integer operateLabelType;
}
