package com.bizvane.members.facade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

@Data
@Builder
public class PayLevelCardBo {

    //等级id
    private Long mbrLevelId;
    //线下等级code
    private String offlineLevelCode;
    //等级名称
    private String levelName;
    //付费卡标志
    private Integer payFlag;
    //入会费
    private BigDecimal payMoney;
    //有效期
    private Integer effectiveYear;
    //到期等级变更
    private Integer levelChangeType;
    //到期等级变更为新等级id
    private Long newLevelId;

    @ApiModelProperty(value = "付费卡类型 1-年卡 2-季卡", name = "payCardType", example = "1")
    private Integer payCardType;

    // 付费卡显示/隐藏状态 1-显示 2-隐藏
    private Integer payCardShowStatus;

    // 季卡有效期，单位天
    private Integer effectiveDay;

    // 购买次数限制，单位次
    private Integer buyNumberLimit;

    // 是否支持升级 0-不支持 1-支持
    private Integer isCanUpgrade;

    // 升级后的等级ids,多选,英文逗号分割
    private String upgradeLevelIds;


}
