package com.bizvane.members.facade.service.ur.inner;

import com.bizvane.members.facade.ur.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

public interface UrOrderService {

    ResponseData<PageInfo<MiniUrOrderResponseVo>> getUrOrderRecord(MiniUrOrderRequestVo miniUrOrderRequestVo);

    /**
     * 保存订单信息
     *
     * @param urSaveOrderRequestVo
     * @return
     */
    ResponseData<String> saveOrderForm(UrSaveOrderRequestVo urSaveOrderRequestVo);

    /**
     * 查询订单信息
     *
     * @param urOrderQueryRequestVo
     * @return
     */
    ResponseData<PageInfo<UrOrderQueryResponseVo>> queryOrderInfo(UrOrderQueryRequestVo urOrderQueryRequestVo);


    ResponseData<Integer> updateOrderEvaluate(UrOrderUpdateVo urOrderUpdateVo);

    ResponseData<PageInfo<UrRechargeConsumeRecordResVo>> queryConsumeRecord(String memberCode,Long sysCompanyId, Integer pageNumber, Integer pageSize);

    ResponseData<UrRechargeConsumeRecordDetailResVo> queryRechargeCardConsumeRecordDetail(UrRechargeConsumeRecordDetailReqVo vo);

    /**
     * ur订单重新推送订单活动消息
     * @param stageUser
     * @return
     */
    ResponseData urOrderActivityMq(SysAccountPO stageUser);

    ResponseData<UrConsumeStatisticsResVo> consumeStatistics(UrConsumeStatisticsReqVo vo);

    ResponseData<PageInfo<UrSaveOrderRequestVo>> queryOrderInfoList(UrQueryOrderListRequestVo requestVo);
}
