package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrMemberApiService {

    /**
     * 根据卡号查询会员
     *
     * @param memberRequestCardNoVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/getMembersInfoByCardNo", method = RequestMethod.POST)
    ResponseData<MemberResponseCardNoVo> getMembersInfoByCardNo(@RequestBody @Valid MemberRequestCardNoVo memberRequestCardNoVo);

    /**
     * 高级搜索查询会员列表
     *
     * @param membersEsRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/getMembersList", method = RequestMethod.POST)
//    @Deprecated
    ResponseData<List<MembersEsResponseVo>> getMembersList(@RequestBody @Valid MembersEsRequestVo membersEsRequestVo);


    /**
     * 高级搜索查询会员列表（分页 默认查询第1页前1000条数据）
     *
     * @param membersEsRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/getMembersListPageable", method = RequestMethod.POST)
    ResponseData<PageInfo<MembersEsResponseVo>> getMembersListPageable(@RequestBody @Valid MembersEsRequestVo membersEsRequestVo);


    /**
     * 当前条件下是否存在会员
     *
     * @param membersExistRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/existMembers", method = RequestMethod.POST)
    ResponseData<Boolean> existMembers(@RequestBody @Valid MembersExistRequestVo membersExistRequestVo);


    /**
     * 根据卡号条件查询单条会员信息,返回信息带等级信息
     *
     * @param singleMembersInfoWithLevelRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/getSingleMembersInfoWithLevel", method = RequestMethod.POST)
    ResponseData<SingleMembersInfoWithLevelResponseVo> getSingleMembersInfoWithLevel(@RequestBody @Valid SingleMembersInfoWithLevelRequestVo singleMembersInfoWithLevelRequestVo);


    /**
     * 根据卡号, 查询UR企业品牌范围内所有会员, 品牌之间会员用手机号关联
     *
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/api/urMembers/getListBrandMembersByCardNo", method = RequestMethod.POST)
    ResponseData<List<UrMemberCardInfoVo>> getListBrandMembersByCardNo(@RequestBody @Valid UrMemberCardInfoReqVo reqVo);



}
