package com.bizvane.members.facade.vo.qywx;

import java.util.List;

import javax.validation.Valid;

import com.bizvane.members.facade.es.vo.SearchExternalRequest;
import com.bizvane.members.facade.es.vo.SearchGuideRequest;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class MainIndexDefinedGroupRequestVo {

	@ApiModelProperty(value = "企业id", name = "sysCompanyId", required = false)
	private Long sysCompanyId;

	@ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
	@Valid
	private Long sysBrandId;

	@ApiModelProperty(value = "店铺集合", name = "storeList", required = false)
	private List<Long> storeList;

	// 所属导购
	private SearchExternalRequest<SearchGuideRequest> serviceGuide;
	
	@ApiModelProperty(value = "导购id", name = "guideId", required = false)
	@Valid
	private Long guideId;
	
	@ApiModelProperty(value = "分组查询条件", name = "groupName", required = false)
	private String	groupName;
	
}
