package com.bizvane.members.facade.models;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 会员微信渠道
 *
 * @author houkai
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_wx_channel")
public class MbrWxChannelModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = 18818283432561951L;

    @ApiModelProperty(value = "主键id", name = "mbrWxChannelId", example = "主键id")
    private Long mbrWxChannelId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "会员code", name = "memberCode", example = "会员code")
    private String memberCode;

    @ApiModelProperty(value = "微信openid", name = "openId", example = "微信openid")
    private String openId;

    @ApiModelProperty(value = "微信unionid", name = "unionId", example = "微信unionid")
    private String unionId;

    @ApiModelProperty(value = "appid", name = "appid", example = "appid")
    private String appid;

    @ApiModelProperty(value = "微信昵称", name = "wxNick", example = "微信昵称")
    private String wxNick;

    @ApiModelProperty(value = "微信头像", name = "headPortraits", example = "微信头像")
    private String headPortraits;

    @ApiModelProperty(value = "是否关注,1：未关注,2：已关注", name = "focus", example = "是否关注,1：未关注,2：已关注")
    private Integer focus;

    @ApiModelProperty(value = "关注时间", name = "focusTime", example = "关注时间")
    private Date focusTime;

    @ApiModelProperty(value = "取关时间", name = "unfocusTime", example = "取关时间")
    private Date unfocusTime;

    @ApiModelProperty(value = "公众号", name = "publicId", example = "公众号")
    private Long publicId;

    @ApiModelProperty(value = "推荐人openid", name = "referrerOpenid", example = "推荐人openid")
    private String referrerOpenid;

    @ApiModelProperty(value = "绑卡状态1：未绑卡,2已绑卡", name = "status", example = "绑卡状态1：未绑卡,2已绑卡")
    private String cardStatus;

    //@ApiModelProperty(value = "是否为粉丝: 1:是; 0:否", name = "isFans")
    //private String isFans;

    @ApiModelProperty(value = "推荐人昵称", name = "referrerNick", example = "推荐人昵称")
    private String referrerNick;

    @ApiModelProperty(value = "是否小程序：1微信2小程序", name = "miniProgram", example = "")
    private Integer miniProgram;

}
