package com.bizvane.members.facade.vo;

import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class CardGenerateVO {

    @NotNull
    public Long sysCompanyId;

    @NotNull
    private Long brandId;

    /**
     * //卡号唯一code
     */
    @NotNull
    private String code;

    /**
     * //初始值 默认从1开始
     */
    private Long initValue = 1L;

    /**
     * //精度 默认8位
     */
    private Long precision = 8L;

    /**
     * //一次返回多个卡号
     */
    private Integer num = 1;

    @Override
    public String toString() {
        return sysCompanyId + "_" + brandId + "_" + code;
    }
}
