package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class StatisticsMemberOrderEvaluateVo implements Serializable {

    private static final long serialVersionUID = -4247228885286101954L;

    @ApiModelProperty(value = "sysCompanyId", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "memberCode", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "平均商品评分", name = "avgProductScore")
    private BigDecimal avgProductScore;

    @ApiModelProperty(value = "平均环境评分", name = "avgStoreEnvironmentGrade")
    private Integer avgStoreEnvironmentGrade;

    @ApiModelProperty(value = "平均服务评分", name = "avgStoreServerGrade")
    private Integer avgStoreServerGrade;

    @ApiModelProperty(value = "评价单数", name = "evaluationOrderNumber")
    private Integer evaluationOrderNumber;

    @ApiModelProperty(value = "好评单数", name = "evaluationGoodOrderNumber")
    private Integer evaluationGoodOrderNumber;

    @ApiModelProperty(value = "好评率", name = "evaluationGoodOrderRate")
    private BigDecimal evaluationGoodOrderRate;

    @ApiModelProperty(value = "差评单数", name = "evaluationBadOrderNumber")
    private Integer evaluationBadOrderNumber;

    @ApiModelProperty(value = "差评率", name = "evaluationBadOrderRate")
    private BigDecimal evaluationBadOrderRate;

}
