package com.bizvane.members.facade.models.third;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuantq
 * @date 2023/12/5
 */
@Data
public class ThirdMbrMemberInfoUpdateBO implements Serializable {

    public ThirdMbrMemberInfoUpdateBO() {
        super();
    }

    private static final long serialVersionUID = 5141183015400729447L;

    public ThirdMbrMemberInfoUpdateBO(Long sysCompanyId, Long sysBrandId, String memberCode, String name, Date birthday, String gender) {
        this.sysCompanyId = sysCompanyId;
        this.sysBrandId = sysBrandId;
        this.memberCode = memberCode;
        this.name = name;
        this.birthday = birthday;
        this.gender = gender;
    }

    @ApiModelProperty(value="企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value="品牌id")
    private Long sysBrandId;

    @ApiModelProperty(value="会员code")
    private String memberCode;

    @ApiModelProperty(value="会员名称")
    private String name;

    /**
     * 生日
     */
    private Date birthday;

    /**
     * 性别 CRM会员性别,女:1 男:2 未知:3
     */
    private String gender;
}
