package com.bizvane.members.facade.enums;

/**
 * @author zcc
 * @date 2020/12/3 10:38
 * /api/baisonSyncIntegralRecord请求接口,百胜积分类型对照商帆积分类型转换枚举
 **/
public enum BizvaneBaisonBusinessTypeEnum {
    INIT("0", "bizvane-113", "初始建档"),
    consume("1", "bizvane-101", "消费"),
    operate("5", "bizvane-114", "积分调整"),
    clear("7", "bizvane-108", "积分清零"),
    recharge("10", "bizvane-115", "充值积分");

    /**
     * 百胜code
     */
    private String baisonCode;
    /**
     * 商帆code
     */
    private String bizvaneCode;

    /**
     * 描述
     */
    private String msg;

    BizvaneBaisonBusinessTypeEnum(String baisonCode, String bizvaneCode, String msg) {
        this.baisonCode = baisonCode;
        this.bizvaneCode = bizvaneCode;
        this.msg = msg;
    }

    public String getBaisonCode() {
        return baisonCode;
    }

    public String getBizvaneCode() {
        return bizvaneCode;
    }

    public String getMsg() {
        return msg;
    }

    public static String getBizvaneBusinessTypeByBaisonCode(String baisonCode) {
        for (BizvaneBaisonBusinessTypeEnum bizvaneBaisonBusinessTypeEnum : BizvaneBaisonBusinessTypeEnum.values()) {
            if (bizvaneBaisonBusinessTypeEnum.getBaisonCode().equals(baisonCode)) {
                return bizvaneBaisonBusinessTypeEnum.getBizvaneCode();
            }
        }
        return BizvaneBusinessTypeEnum.UR_OTHER.getCode();
    }
}
