package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/13.
 */
public enum OpenCardChannelNegativeEnum {

    /**
     * 会员开卡绑卡渠道 负微信渠道
     * 场景:微信开卡渠道,会员解绑时,避免该字段空指针,开卡设置为默认值,再绑卡时用到
     */
    WECHAT_NEGATIVE_CHANNEL(-2L, "负微信渠道");

    private Long code;

    private String msg;

    OpenCardChannelNegativeEnum(Long code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getOpenCardChanneMessage(Long code) {
        for (OpenCardChannelNegativeEnum type : OpenCardChannelNegativeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }
}
