package com.bizvane.members.facade.vo;

import lombok.Data;

import java.util.List;

@Data
public class GrowthConfigSelectVO {

    private Integer limitGrowth;//int(10) DEFAULT NULL COMMENT '每日上限',
    private Integer buyPriceIncrGrowth;// int(10) DEFAULT NULL COMMENT '消费金额获取成长值',
    private Integer buyNumIncrGrowth;// int(10) DEFAULT NULL COMMENT '消费次数获取成长值',
    private Integer refundPriceDecrGrowth;// int(10) DEFAULT NULL COMMENT '退款金额扣减成长值',
    private Integer refundNumDecrGrowth;// int(10) DEFAULT NULL COMMENT '退款次数扣减成长值',
    private Integer last30DecrGrowth;// int(10) DEFAULT NULL COMMENT '最近30未消费扣减成长值',
    private Integer last90DecrGrowth;// int(10) DEFAULT NULL COMMENT '最近90天未消费扣减成长值',
    private Integer canLevelUp;// int(1) DEFAULT '0' COMMENT '是否升降级',
    private Integer canShow;// int(1) DEFAULT '0' COMMENT '会员卡档案是否显示',
    private Integer canAdjust;// int(1) DEFAULT '0' COMMENT '是否允许会员卡档案调整成长值',
    private String description;// text COMMENT '成长值描述',
    private Integer buyNumTimes;// int(2) DEFAULT '0' COMMENT '每月前几次消费不获得成长值',
    private Integer refundNumTimes;// int(2) DEFAULT NULL COMMENT '每月前？次退款不扣成长值',

    private Integer buyPriceIncrGrowthSwitch;
    private Integer buyNumIncrGrowthSwitch;
    private Integer refundPriceDecrGrowthSwitch;
    private Integer refundNumDecrGrowthSwitch;
    private Integer last30DecrGrowthSwitch;
    private Integer last90DecrGrowthSwitch;


    private List<MemberLevelGrowthMapping> memberLevelGrowthMappings;

    @Data
    public static class MemberLevelGrowthMapping {

        private Long memberLevelId;

        private String levelName;

        private Integer growthNum;

    }

}


