package com.bizvane.members.facade.vo.qywx;

import com.bizvane.members.facade.es.vo.*;
import com.bizvane.members.facade.models.MbrGroupModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class MembersFriendVo {
    // 企业id
    private Long sysCompanyId;
    // 隔离门店
    private List<Long> storeList;
    // 品牌号
    private Long brandId;

    // 导购id----------必填
    private Long guideId;

    // 服务导购--------作为查询条件，选填
    private SearchExternalRequest<SearchGuideRequest> serviceGuide;
    // 好友关系是否存在
    private SearchExternalRequest<SearchFriendsRequest> companyGuideFriends;

    // 会员备注
    private String memberComment;
    // 会员姓名
    private String name;
    // 会员手机号
    private String phone;
    // 微信昵称
    private String wxNick;
    // 0全部 1女 2男 3未知
    private Integer gender;

    // 备注、昵称、姓名或手机号 搜索
    private String friendsConditions;

    // 等级id
    private List<Long> levelID;

    private List<Integer> genderList;

    private Integer pageNum;

    private Integer pageSize;

    private Boolean isDesc;

    private Integer orderType;

    private List<Order> orders;

    //新 生日高级搜索
    private SearchRangeTypeRequest birthdayMdRange;

    // 是否微信会员 1.是 2.否
    private Integer wxMembers;

    //关注公众号 1未关注 2 关注中 3已取关
    private Integer focusPublic;

    // 导购助手角色
    private String staffRoleId;

    /**
     * 二级分组id
     */
    private Long groupId;
    /**
     * 标签id
     */
    private Long mbrLabelDefId;

    /**
     * 自定义分组id
     */
    private Long definedGroupId;

    // 子分组
    private SearchExternalRequest<List<MbrGroupModel>> childMbrGroupDefIds;

    /**
     * 标签id集合
     */
    private List<Long> labelIdList;

    /**
     * 自定义标签id结合
     */
    private List<Long> customLabelIdList;

    /**
     * ture:查询已分配过导购的会员(不包含默认导购的会员)
     * false或者null:按原有查询逻辑
     */
    private Boolean isAssigned;

    @ApiModelProperty("是否商秀显示")
    private Integer shopStatus;

    @ApiModelProperty("生命周期 1活跃会员 2 沉默会员 3 濒临休眠会员 4休眠会员 5流失会员 6未消费会员")
    private Integer memberLiveness;

    @ApiModelProperty("memberCode集合")
    private List<String> memberCodeList;

}
