package com.bizvane.members.facade.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class MemberCouponListRspVo {

    /** 券定义ID，唯一标识一个券定义 */
    private Long couponDefinitionId;

    /** 券的唯一编码 */
    private String couponCode;

    /** 券名称 */
    private String couponName;

    /** 优惠类型：1-现金，2-折扣，3-礼品 */
    private Byte preferentialType;

    /** 关联会员的编码 */
    private String memberCode;

    /** 有效期开始时间（格式：yyyy-MM-dd HH:mm:ss） */
    private Date validDateStart;

    /** 有效期结束时间（格式：yyyy-MM-dd HH:mm:ss） */
    private Date validDateEnd;

    /** 券面额（适用于现金券） */
    private BigDecimal money;

    /** 折扣率（适用于折扣券） */
    private BigDecimal discount;

    /** 券描述信息 */
    private String info;

    /** 使用类型：1-线上，2-线下 */
    private Byte useType;

    /** 使用门店编码 */
    private String useStoreCode;

    /** 使用时关联的业务订单号 */
    private String useBusinessOrder;

    /** 使用订单金额 */
    private BigDecimal useBusinessOrderAmount;

    /** 使用时间（格式：yyyy-MM-dd HH:mm:ss） */
    private Date useTime;

    /** 券状态：20-未使用，25-已过期，30-已核销 */
    private Byte couponStatus;

    /** 是否使用：0-未使用，1-已使用 */
    private Integer isUse;

    /** 转增状态：0-未转增，1-已转增 */
    private Integer give;

    /** 是否锁定：0-未锁定，1-已锁定 */
    private Integer isLock;

    /** 线下券类型编号（ERP系统使用） */
    private String erpCouponDefinitionCode;

    /** 使用渠道限制：1-仅线下，2-全渠道，3-仅线上，4-员工券，5-天猫券 */
    private Byte useChannel;

}
