package com.bizvane.members.facade.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MemberFriendVO implements Serializable {

    /**
     * 好友姓名
     */
    private String friendName;

    /**
     * 好友性别 : 1.女 2.男 3.未知
     */
    private Integer friendGender;

    /**
     * 好友手机号
     */
    private String friendPhone;

    /**
     * 好友关系 :1.好友
     */
    private Integer friendRelation;

    /**
     * 是否是会员 true 是  false 不是
     */
    private Boolean isMember;

    /**
     * 会员卡号
     */
    private String cardNo;
}
