package com.bizvane.members.facade.vo.yanzhiwu;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class MemberOpenCardRequestVo {


    private Long sysCompanyId;//公司id

    private String offlineCompanyCode;

    @NotEmpty
    private String brandCode;//	是	string	品牌
    @NotEmpty
    private String phone;//	是	string	手机号

    private String cardNo;//	是	string	会员卡号
    private String name;    //否	string	会员名称
    private Integer sex;    //否	int	性别 : 1.女 2.男 3.未知
    private String province;//	否	string	省
    private String city;//	否	string	市
    private String county;//	否	string	区
    private String address;//	否	string	会员详细地址
    private String remark;//	否	string	备注
    private String email;//	否	string	会员邮箱
    private String idCard;//	否	string	会员身份证号
    private String birthday;//	否	string	会员生日 格式 : yyyy-mm-dd
    private String storeCode;//	否	string	注册门店code,如果为空则默认按照中台配置的会员卡体系为准
    private String levelCode;//	否	string	会员等级code,如果为空则默认按照中台配置的会员卡体系为准

    //guideCode
    private String guideCode;//否 string 导购code,如果为空则默认按照中台配置的会员卡体系为准

    @NotNull
    private Integer source;//	是	int	会员注册渠道 : 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
    private Integer points;//	否	int	会员可用积分,如果为空则默认为0
    private String unionId;//	否	string	微信unionId
    private Integer valid;//	否	int	会员卡状态 : 0.禁用 1.可用,默认为1
    @NotEmpty
    private String erpId;// 否 string erpId
    private Date openCardTime;
    @ApiModelProperty(value = "第三方openId", name = "openId",notes="根据source的类型来区分不同的openID，source是有赞渠道，则对应openid是有赞id")
    private String openId;

    /**
     * 服务导购
     * */
    private String serviceGuideCode;

    /**
     * 服务导购电话
     * */
    @ApiModelProperty(value = "服务导购电话", name = "serviceGuidePhone",notes="根据电话查询导购信息")
    private String serviceGuidePhone;

    /**
     * 服务门店
     * */
    private String serviceStoreCode;

    @ApiModelProperty(value = "依文定制内容-有赞开卡对接传入", name = "wxOpenId",notes="")
    private String wxOpenId;

    @ApiModelProperty(value = "依文定制内容-有赞开卡对接传入appid", name = "wxAccountId",notes="")
    private String wxAccountId;

    @ApiModelProperty(value = "依文定制内容-有赞开卡对接传入第三方门店id", name = "shopId",notes="")
    private String shopId;

    /**
     * 邀请人会员手机号
     */
    private String inviterPhone;

    /**
     * 自定义属性json串 {"extendOfflineCode1":"value1","extendOfflineCode2":"value2"}
     */
    private String extendProperty;

}
