package com.bizvane.members.facade.service.datafetch.model;

import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author dingShiChen
 * @since 2019/10/12
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class MemberRelationFetchModel extends BaseFetchModel implements Serializable {

	private static final long serialVersionUID = 6477605981682105746L;

	/**
	 * 亲属名称
	 */
	private String relationName;

	/**
	 * 亲属性别,1女、2男、3未知
	 */
	private String relationGender;

	/**
	 * 亲属生日
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date relationBirthday;

	/**
	 * 亲属手机号
	 */
	private String relationPhone;

	/**
	 * 亲属openid
	 */
	private String relationOpenid;

	/**
	 * 亲属关系，1子女、2父母、3夫妻
	 */
	private String relation;

	/**
	 * 线下新增时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date addTime;


	/**
	 * 线上会员code，这三个字段不取不校验，用来组装查询
	 */
	private String memberCode;
	private Long sysCompanyId;
	private Long sysBrandId;
}

