package com.bizvane.members.facade.service.datafetch.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/8/10 10:43
 * @Description: 会员卡信息取数器对象
 */
@Data
public class MemberCardInfoFetchModel extends BaseFetchModel implements Serializable {

    private static final long serialVersionUID = 4484908290397923520L;

    private String cardNo; //会员卡号

    private String offlineCardNo; //线下卡号

    private String name; //会员名称

    private String phone; //会员手机号

    private String idCard; //身份证

    private String gender; //会员性别,女：1 男：2 未知:3

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday; //会员生日

    private String birthdayMd; //冗余生日时间的格式月日,例如：0101

    private String province; //会员省份

    private String city; //会员市区

    private String county; //会员区

    private String address; //详细地址

    private String email; //会员邮箱

//    private String headPortraits; //会员头像

//    private String erpId; //线下会员id

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date openCardTime; //开卡时间

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date bindCardTime; //绑卡时间

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveTime; //卡有效期

    private Integer memberSource; //1:线下2：微信3：手淘4：支付宝

    private Integer openCardChannelId; //开卡渠道id：1:线下2：微信3：手淘4：支付宝

//    private String allChannelIds; //全渠道会员卡

    private String generalizeChannel; //推广渠道

    private String openCardGuideCode; //线下开卡导购code

    private String offlineDealerAttributionCode; //线下归属经销商code

    private String dealerAttributionName; //线下归属经销商name

    private String openCardStoreCode; //开卡门店code

    private String serviceStoreCode; //服务门店code

    private String serviceGuideCode; //服务导购code

    private String offlineLevelCode; //会员等级code

    private Integer countIntegral; //会员累计可用总积分

    private String remark; //备注

    private Integer addUpIntegral; //累计收入的总积分

    private Integer aboutExpireIntegral; //即将到期积分

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date aboutExpireTime;//即将到期时间

    @ApiModelProperty(value = "已过期积分", name = "pastDueIntegral", example = "已过期积分")
    private Integer pastDueIntegral;

    @ApiModelProperty(value = "已消耗积分", name = "consumeIntegral", example = "已消耗积分")
    private Integer consumeIntegral;

    @ApiModelProperty(value = "冻结积分", name = "consumeIntegral", example = "冻结积分")
    private Integer freezeIntegral;

    @ApiModelProperty(value = "扩展字段", name = "extend", example = "{\"babyName\":\"baby\",\"babySex\":\"女\",\"dueDate\":\"2019-01-01 00:00:00\"}")
    private String extend;

    @ApiModelProperty(value = " 数据有效性：1=有效；0=无效(不传默认1)", name = "valid", example = "1")
    private Integer valid;

    @ApiModelProperty(value = "余额", name = "balance", example = "1.0")
    private BigDecimal balance;

    @ApiModelProperty(value = "储值卡号", name = "petCard")
    private String petCard;

    @ApiModelProperty(value = "注册类型", name = "registerType")
    private Integer registerType;

    @ApiModelProperty(value = "原始店铺code", name = "orgStoreCode")
    private String orgStoreCode;

    @ApiModelProperty(value = "361公司编码", name = "zipCode")
    private String zipCode;

    @ApiModelProperty(value = "会员卡状态",name = "cardUseStatus")
    private Integer cardUseStatus;


    private Long openCardStoreId;

    private Long serviceStoreId;

    private Long openCardGuideId;

    private Long serviceGuideId;

    private String areaCode;
}
