package com.bizvane.members.facade.utils;

import com.bizvane.members.facade.enums.MemberAuthorizeTaskStatusEnum;
import com.bizvane.members.facade.models.po.MemberAuthorizePo;
import io.swagger.models.auth.In;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 公共入参校验
 *
 * @author SF
 */
public class MemberAuthorizeTaskUtil {

    private static final String preNumStr = "AU";

    /**
     * 生成task编号
     * 编号生成规则：AU开头+年月日+时分秒+四位随机流水号，如AU202306201131450001）
     */
    public static String genTaskNumStr(MemberAuthorizePo memberAuthorizePo, Date nowTime) {

        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");

        String formatDateTime = formatter.format(nowTime);

        Integer random = new Random().nextInt(10000);

        String serialNumStr = String.format("%04d", random);

        return preNumStr + formatDateTime + serialNumStr;
    }

    /**
     * 判断task的status
     *
     * @param memberAuthorizePo
     * @param nowTime
     * @return
     */
    public static void judgmentStatus(MemberAuthorizePo memberAuthorizePo, Date nowTime) {
        //如果status为null（说明调用请求为新增task）时，或者当status不为DISABLED（任务状态为已禁用）时进入循环
        if (memberAuthorizePo.getStatus() == null || !memberAuthorizePo.getStatus().equals(MemberAuthorizeTaskStatusEnum.DISABLED.getTypeCode())) {
            //设置状态为未执行
            if (memberAuthorizePo.getMbrAuthorizeTaskStartTime().compareTo(nowTime) > 0) {
                memberAuthorizePo.setStatus(MemberAuthorizeTaskStatusEnum.UN_EXECUTION.getTypeCode());
                return;
            }
            //设置状态为已结束
            if (memberAuthorizePo.getMbrAuthorizeTaskEndTime().compareTo(nowTime) < 0) {
                memberAuthorizePo.setStatus(MemberAuthorizeTaskStatusEnum.EXECUTED.getTypeCode());
                return;
            } else {
                //设置状态为执行中
                memberAuthorizePo.setStatus(MemberAuthorizeTaskStatusEnum.UNDER_EXECUTION.getTypeCode());
            }
        }
    }
}
