package com.bizvane.members.facade.vo;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/8/22 14:15
 * @Description: 会员标签列表查询返回实体
 */
@Data
public class MemberLabelInfoRes implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long sysBrandId;

    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "集团卡会员标签",name = "labelNames")
    private List<MemberLabelResVO> officialLabels;

    @ApiModelProperty(value = "集团卡会员标签",name = "labelNames")
    private List<MemberLabelResVO> customLabels;

    @ApiModelProperty(value = "集团卡会员标签",name = "labelNames")
    private List<MemberLabelResVO> qaLabels;

    public static MemberLabelInfoRes createDefaultRes(Long sysCompanyId, Long sysBrandId, String memberCode) {
        MemberLabelInfoRes memberLabelInfoRes = new MemberLabelInfoRes();
        memberLabelInfoRes.setSysCompanyId(sysCompanyId);
        memberLabelInfoRes.setSysBrandId(sysBrandId);
        memberLabelInfoRes.setMemberCode(memberCode);

        memberLabelInfoRes.setQaLabels(Lists.newArrayList());
        memberLabelInfoRes.setCustomLabels(Lists.newArrayList());
        memberLabelInfoRes.setOfficialLabels(Lists.newArrayList());
        return memberLabelInfoRes;
    }
}
