package com.bizvane.members.facade.vo.vg;

import com.bizvane.centerstageservice.models.po.FileTaskPo;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class VGIntegralRechargeRecordSearchRequestVO {

    @NotNull(message = "sysCompanyId不能为空")
    private Long sysCompanyId;

    @NotNull(message = "sysBrandId不能为空")
    private Long sysBrandId;

    /**
     * 搜索条件 （会员卡号/姓名/手机号）
     */
    private String condition;

    /**
     * 微信支付订单号
     */
    private String bizOrderNo;

    /**
     * 充值订单号
     */
    private String orderNo;

    /**
     * 会员卡号
     */
    private String cardNo;

    /**
     * 会员手机号
     */
    private String phone;

    /**
     * 会员姓名
     */
    private String name;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private int pageNumber = 1;
    private int pageSize = 10;

    private FileTaskPo fileTaskPo;
}
