package com.bizvane.members.facade.vo.vg;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author lijiachun
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class VGMemberIntegralRecordVO {

    @NotEmpty(message = "brandCode必须填")
    private String brandCode;

    private String cardNo = "";

    private String serialNumber = "";

    private Integer pageNo = 1;

    private Integer pageSize = 10;

    private Integer changeWay;

    @NotNull(message = "sysCompanyId不能为空")
    private Long sysCompanyId;
}
