package com.bizvane.members.facade.models.query;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/9/4 14:24
 * @Description: 订单评价页面查询条件实体
 */
@Data
public class OrderEvaluateQueryPo {

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @ApiModelProperty(value = "评价时间max", name = "evaluateTimeMax", example = "评价时间max")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date evaluateTimeMax;

    @ApiModelProperty(value = "评价时间min", name = "evaluateTimeMin", example = "评价时间min")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date evaluateTimeMin;

    @ApiModelProperty(value = "订单编号", name = "orderNo", example = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "店铺名", name = "storeName", example = "店铺名")
    private String storeName;

    @ApiModelProperty(value = "导购名", name = "guideName", example = "导购名")
    private String guideName;

    @ApiModelProperty(value = "商品名", name = "productName", example = "商品名")
    private String productName;

    @ApiModelProperty(value = "店铺环境评分（最高5分）", name = "storeEnvironmentGrade", example = "店铺环境评分（最高5分）")
    private Integer storeEnvironmentGrade;

    @ApiModelProperty(value = "店铺服务评分（最高5分）", name = "storeServerGrade", example = "店铺服务评分（最高5分）")
    private Integer storeServerGrade;

    @ApiModelProperty(value = "当前用户管辖店铺列表", name = "storeList", example = "当前用户管辖店铺列表")
    private List<Long> storeList;

    /**
     * 从第几条记录开始 导出excel使用
     */
    private Long start;
    /**
     * 读取几条记录 导出excel使用
     */
    private Long size;
}
