package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVo;
import com.bizvane.members.facade.models.po.MbrTmallConfigPO;
import com.bizvane.members.facade.vo.taobao.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * 天猫会员通店铺服务
 * @author huangxinliu
 * @date: 2021/1/26 9:44
 */
public interface MbrTmallConfigService {

    /**
     * 店铺分页
     */
    PageInfo<MbrTmallConfigPO> page(MbrTmallConfigPO queryVo, PageVo pageVo, SysAccountPO currentUser);

    /**
     * 店铺新增
     */
    ResponseData add(MbrTmallConfigAddReqVo reqVo, SysAccountPO currentUser);

    /**
     * 店铺修改
     */
    ResponseData save(MbrTmallConfigUpdateReqVo reqVo, SysAccountPO currentUser);

    /**
     * 店铺解绑授权
     */
    void unbind(MbrTmallConfigBaseReqVo reqVo, SysAccountPO currentUser);

    /**
     * 店铺授权状态更新
     */
    void updateAuthState(MbrTmallConfigUpdateAuthStateReqVo reqVo);

    /**
     * 店铺详情-单条数据
     */
    MbrTmallConfigPO detail(Long id);

    /**
     * 店铺详情-页面展示
     */
    MbrTmallConfigResVo detailMore(Long id);

    /**
     * 商帆默认开卡等级变动联动更新默认天猫等级
     * @param sysCompanyId 企业id
     * @param brandId 品牌id
     * @param mbrLevelId 会员等级id
     */
    void updateTmallLevelOfMbrLevelId(Long sysCompanyId, Long brandId, Long mbrLevelId);
}
