package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 会员标签model
 * <p>
 * 内部使用
 *
 * @author houkai
 */

@Data
@NoArgsConstructor
@Table(name = "t_mbr_label_def")
public class MemberLabelModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = 7593378701508448025L;

    @Id
    @ApiModelProperty(value = "标签id", name = "labelId", example = "标签id")
    private Long mbrLabelDefId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "所属品牌", name = "brandId", example = "所属品牌")
    private Long brandId;

    @ApiModelProperty(value = "标签编号", name = "labelCode", example = "标签编号")
    private String labelCode;

    @ApiModelProperty(value = "标签名称", name = "labelName", example = "标签名称")
    private String labelName;

    @ApiModelProperty(value = "标签类型", name = "labelType", example = "标签类型")
    private String labelType;

    @ApiModelProperty(value = "标签分组", name = "labelGroupId", example = "标签分组")
    private Long labelGroupId;

    @ApiModelProperty(value = "使用次数", name = "count", example = "使用次数")
    private Integer count;

    @ApiModelProperty(value = "标签名数组", name = "labelNameList", example = "标签名数组")
    private List<String> labelNameList;

    /**
     * 是否加入回收站 1是 0否
     */
    private Boolean recycle;

    private List<Map> labelMap;

}
