package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.service.card.request.FocusOnRequestModel;
import com.bizvane.members.facade.service.card.response.FocusOnResponseModel;
import com.bizvane.utils.enumutils.SysResponseEnum;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/11.
 */
@Slf4j
public abstract class AbstractApiOnFocusService {

	/**
	 * 验证数据有效性
	 * 
	 * @param focusOnRequestModel
	 * @return
	 */
	public abstract void validationData(FocusOnRequestModel focusOnRequestModel);

	/**
	 * 查询当前微信用户信息是否存在
	 * 
	 * @return
	 */
	public abstract FocusOnResponseModel queryWxMemberInfo(FocusOnRequestModel focusOnRequestModel);

	/**
	 * 更新微信用户数据
	 * 
	 * @param focusOnResponseModel
	 * @return
	 */
	public abstract void updateWxMemberInfo(FocusOnResponseModel focusOnResponseModel);

	/**
	 * 添加微信用户数据
	 * 
	 * @param focusOnResponseModel
	 * @return
	 */
	public abstract void addWxMemberInfo(FocusOnResponseModel focusOnResponseModel);

	/**
	 * 查询当前微信用户信息是否存在(根据brandId和unionId查)兼容查询
	 * 
	 * @return
	 */
	public abstract FocusOnResponseModel queryWxMemberInfoByUnionIdAndBrandId(FocusOnRequestModel focusOnRequestModel,
			FocusOnResponseModel focusOnResponseModel);

	/**
	 * 关注
	 * 
	 * @param focusOnRequestModel
	 * @return
	 */
	protected FocusOnResponseModel focus(FocusOnRequestModel focusOnRequestModel) {
		// 验证数据
		this.validationData(focusOnRequestModel);
		// 查询数据
		FocusOnResponseModel focusOnResponseModel = this.queryWxMemberInfo(focusOnRequestModel);
		focusOnResponseModel.setMessage("返回微信用户信息");
		if (SysResponseEnum.SUCCESS.getCode() == focusOnResponseModel.getCode()) {
			log.info("微信粉丝表已有数据，更新微信数据");
			updateWxMemberInfo(focusOnResponseModel);
		}
		if (SysResponseEnum.FAILED.getCode() == focusOnResponseModel.getCode()) {
			log.info("微信粉丝表无数据，需要新增数据，openid:{}", focusOnRequestModel.getOpenId());
			addWxMemberInfo(focusOnResponseModel);
		}
		if (SysResponseEnum.FAILED.getCode() == focusOnResponseModel.getCode()) {
			focusOnResponseModel = queryWxMemberInfoByUnionIdAndBrandId(focusOnRequestModel, focusOnResponseModel);
		}
		return focusOnResponseModel;
	}
}
