package com.bizvane.members.facade.vo;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/13.
 */
@Data
public class ExtendPropertyValueVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "属性code", name = "propertyCode")
	private String propertyCode;

	@ApiModelProperty(value = "属性名称", name = "propertyName")
	private String propertyName;

	@ApiModelProperty(value = "属性类型：1.单选,2.多选,3.时间,4.数字,5.文本", name = "propertyType")
	private String propertyType;

	@ApiModelProperty(value = "属性值", name = "propertyValue")
	private String propertyValue;

	@ApiModelProperty(value = "属性选项", name = "propertyOption")
	private String propertyOption;

	@ApiModelProperty(value = "是否可见", name = "visible")
	private String visible;

	@ApiModelProperty(value = "是否允许编辑", name = "edit")
	private String edit;

	@ApiModelProperty(value = "是否必填 1非必传,2必传", name = "required")
	private String required;

	@ApiModelProperty(value = "排序规则", name = "sorted")
	private Integer sorted;

	@ApiModelProperty(value = "会员code", name = "memberCode")
	private String memberCode;

	@ApiModelProperty(value = "品牌id", name = "brandId")
	private Long brandId;

	@ApiModelProperty(value = "企业id", name = "sysCompanyId")
	private Long sysCompanyId;

	@ApiModelProperty(value = "操作人id", name = "operateUserId")
	private Long operateUserId;

	@ApiModelProperty(value = "操作人姓名", name = "operateUserName")
	private String operateUserName;

	@ApiModelProperty(value = "属性状态：0启用 1禁用", name = "status")
	private String status;

	@ApiModelProperty(value = "对应线下属性", name = "offlinePropertyCode")
	private String offlinePropertyCode;

	@ApiModelProperty(value = "是否写入线下", name = "writeToOffline")
	private Integer writeToOffline;

	@ApiModelProperty(value = "冗余字段", name = "extraInfo")
	private String extraInfo;
	
	@ApiModelProperty(name = "perfectFieldTask",value = "小程序使用")
    private String perfectFieldTask;

	@ApiModelProperty(value = "定义类型:1、基本属性；2、拓展属性", name = "defType")
	private Integer defType;
}
