package com.bizvane.members.facade.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.function.Consumer;

/**
 * @author dingshichen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UpdateLevel {

    @NotNull
    private Long companyId;

    @NotNull
    private Long brandId;

    @NotEmpty
    private String cardNo;

    @NotEmpty
    private String erpId;

    @NotEmpty
    private String phone;

    @NotEmpty
    private String newLevelCode;

    @NotNull
    private Long newLevelId;

    /**
     * 更新下线数据
     * @param consumer
     */
    public void updateSingleOffline(Consumer<UpdateLevel> consumer){
        consumer.accept(this);
    }

    /**
     * 循环更新多个品牌线上数据
     * @param consumer
     */
    public void updateAllOnline(Consumer<UpdateLevel> consumer){
        consumer.accept(this);
    }

    /**
     * 更新到es
     * @param consumer
     */
    public void updateES(Consumer<UpdateLevel> consumer){
        consumer.accept(this);
    }
}
