package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.MemberInfoModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/13.
 */
@Data
public class MemberInfoVo extends MemberInfoModel {

    @ApiModelProperty(value = "扩展属性列表", name = "extendPropertyList")
    private List<ExtendPropertyValueVO> extendPropertyList;

    @ApiModelProperty(value = "会员所属门店", name = "memberStoreName")
    private String memberStoreName;

    @ApiModelProperty(value = "会员所属导购", name = "memberGuideName")
    private String memberGuideName;

    @ApiModelProperty(value = "会员所属品牌", name = "brandName")
    private String brandName;

    @ApiModelProperty(value = "微信昵称", name = "wxNick")
    private String wxNick;

    @ApiModelProperty(value = "是否关注,1：未关注,2：已关注", name = "focus", example = "是否关注,1：未关注,2：已关注")
    private Integer focus;

    @ApiModelProperty(value = "会员标签",name = "labelNames")
    private String labelNames;

    @ApiModelProperty(value = "是否具有品牌邮箱配置",name = "isBrandEmailConfig")
    private Boolean isBrandEmailConfig;
}
