package com.bizvane.members.facade.service.card.response;

import com.bizvane.centerstageservice.models.po.SysStorePo;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Data
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
public class PushMbrModel {


    /**
     * 基础信息
     */
    @ApiModelProperty(name = "sysCompanyId", value = "sysCompanyId")
    private Long sysCompanyId;
    @ApiModelProperty(name = "brandId", value = "brandId")
    private Long brandId;

    @ApiModelProperty(name = "appId", value = "appId")
    private String appId;

    @ApiModelProperty(name = "publicId", value = "publicId")
    private Long publicId;

    @ApiModelProperty(name = "unionId", value = "unionId")
    private String unionId;

    @ApiModelProperty(name = "openId", value = "openId")
    private String openId;

    @ApiModelProperty(name = "wxNick", value = "微信昵称")
    private String wxNick;

    @ApiModelProperty(name = "headPortraits", value = "微信头像")
    private String headPortraits;

    @ApiModelProperty(name = "name", value = "姓名")
    private String name;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    @ApiModelProperty(name = "gender", value = "性别")
    private String gender;

    @ApiModelProperty(name = "birthday", value = "生日")
    private Date birthday;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "city", value = "城市")
    private String city;

    @ApiModelProperty(name = "county", value = "区县")
    private String county;

    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;

    @ApiModelProperty(name = "email", value = "邮箱")
    private String email;

    @ApiModelProperty(name = "idCard", value = "身份证")
    private String idCard;


    @ApiModelProperty(name = "erpId", value = "线下id")
    private String erpId;
    /**
     * 会员信息
     */

    @ApiModelProperty(name = "memberCode", value = "会员code")
    private String memberCode;

    @ApiModelProperty(name = "openCardTime", value = "开卡时间")
    private Date openCardTime;

    @ApiModelProperty(name = "levelId", value = "等级id")
    private Long levelId;

    @ApiModelProperty(name = "levelName", value = "等级名称")
    private String levelName;

    @ApiModelProperty(name = "countIntegral", value = "累计可用积分")
    private Integer countIntegral;

    @ApiModelProperty(name = "cardNo", value = "线上卡号")
    private String cardNo;

    @ApiModelProperty(name = "offlineCardNo", value = "线下卡号")
    private String offlineCardNo;

    @ApiModelProperty(name = "storesName", value = "门店")
    private String storesName;

    @ApiModelProperty(value = "开卡店铺id", name = "openCardStoreId")
    private Long openCardStoreId;

    @ApiModelProperty(value = "开卡导购id", name = "openCardGuideId")
    private Long openCardGuideId;

    @ApiModelProperty(value = "服务导购id", name = "serviceGuideId")
    private Long serviceGuideId;

    @ApiModelProperty(value = "服务导购店铺id", name = "serviceStoreId")
    private Long serviceStoreId;

    @ApiModelProperty(name = "cardStatus", value = "绑卡状态：1绑卡、2未帮卡")
    private Integer cardStatus;

    @ApiModelProperty(name = "operateType", value = "操作类型:0.已绑过,1绑卡，2注册")
    private Integer operateType;

    @ApiModelProperty(value = "注册时间", name = "注册时间")
    private String inviteRegisterTime;


    //线下code字段
    @ApiModelProperty(name = "offlineCompanyCode", value = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(name = "offlineBrandCode", value = "线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty(name = "offlineLevelCode", value = "等级code")
    private String offlineLevelCode;

    @ApiModelProperty(name = "openCardStoreCode", value = "开卡门店code")
    private String openCardStoreCode;

    @ApiModelProperty(name = "openCardGuideCode", value = "开卡导购code")
    private String openCardGuideCode;

    @ApiModelProperty(name = "serviceStoreCode", value = "服务门店code")
    private String serviceStoreCode;

    @ApiModelProperty(name = "serviceGuideCode", value = "服务导购code")
    private String serviceGuideCode;


    /**
     * 业务类型
     */
    @ApiModelProperty(name = "sceneId", value = "业务类型id")
    private Long sceneId;

    @ApiModelProperty(name = "sceneValue", value = "业务类型值")
    private String sceneValue;

    @ApiModelProperty(name = "sourceWay", value = "业务类型")
    private String sourceWay;

    public static void main(String[] args) {
        Map<String,String> op = Stream.of("", null).
                filter(store -> StringUtils.isNotBlank(store)).distinct().
                map(code ->{
                    System.out.println(1);
                    return "1";
                }).collect(Collectors.toMap(String::toString,Function.identity()));
        System.out.println(op.toString());
        System.out.println(op==null);
        System.out.println(op.isEmpty());
    }

}
