package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.query.GroupAnalyzePo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/9/14 18:07
 * @Description:
 */
@RestController
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface GroupAnalyzeApiService {
    /**
     * 查询所有默认分组
     *
     * @return
     */
    @RequestMapping(value = "/api/queryAllDefaultGroup", method = RequestMethod.POST)
    ResponseData<List<GroupAnalyzePo>> queryAllDefaultGroup();

    /**
     * 查询所有自定义分组
     *
     * @return
     */
    @RequestMapping(value = "/api/queryAllCustomGroup", method = RequestMethod.POST)
    ResponseData<List<GroupAnalyzePo>> queryAllCustomGroup();
}
