package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @Author: houkai
 * @Date: 2018/7/17 19:32
 * @Description:
 */
public interface MemberGroupService {
    /**
     * 新建会员分组
     *
     * @param mbrGroupModel
     * @return
     * @throws MemberException
     */
    ResponseData addGroup(MbrGroupModel mbrGroupModel) throws MemberException;

    /**
     * 查询会员分组详情
     *
     * @param mbrGroupDefId
     * @return
     */
    ResponseData<MbrGroupModel> queryGroupInfo(Long mbrGroupDefId);

    /**
     * 编辑会员分组信息
     *
     * @param mbrGroupModel
     * @return
     */
    ResponseData updateMemberGroup(MbrGroupModel mbrGroupModel);

    /**
     * 查询分组类型内会员分组列表
     *
     * @param mbrGroupModel
     * @param pageVo
     * @return
     */
    ResponseData<PageInfo<MbrGroupModel>> queryGroupList(MbrGroupModel mbrGroupModel, PageVo pageVo);

    /**
     * 复制会员分组
     *
     * @param mbrGroupDefId
     * @param currentUser
     * @return
     */
    ResponseData addGroupByCopy(Long mbrGroupDefId, SysAccountPO currentUser);

    /**
     * 根据筛选条件查询会员个数
     *
     * @param conditions
     * @param currentUser
     * @return
     */
    ResponseData<Long> queryMemberCount(MembersInfoSearchVo searchVo);
}
