package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.utils.responseinfo.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/17.
 */
@Data
public class ConsumeRecordVo implements Serializable{

    private static final long serialVersionUID = -5720730499551371604L;

    @ApiModelProperty(value = "累计消费金额", name = "totalConsume")
    private BigDecimal totalConsume;

    @ApiModelProperty(value = "累计订单数", name = "totalOrder")
    private Long totalOrder;

    @ApiModelProperty(value = "会员姓名", name = "name")
    private String name;

    @ApiModelProperty(value = "会员卡号", name = "cardNo")
    private String cardNo;

    @ApiModelProperty(value = "会员卡等级",name = "levelName")
    private String levelName;

    @ApiModelProperty(value = "订单详情", name = "orderDetail")
    private PageInfo<OrderVo> orderDetail;
}
