package com.bizvane.members.facade.service.card.util;

import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/9/14.
 */
public class OpenCardResponseUtil {

    private static final ThreadLocal <ResponseOpenCardModel> threadLocal = new ThreadLocal <ResponseOpenCardModel>();

    /**
     * 获取相应数据对象
     *
     * @return
     */
    public static ResponseOpenCardModel getResponse() {
        ResponseOpenCardModel responseOpenCardModel = threadLocal.get();
        if (responseOpenCardModel == null) {
            responseOpenCardModel = new ResponseOpenCardModel();
            threadLocal.set(responseOpenCardModel);
        }
        return responseOpenCardModel;
    }


    public static ResponseOpenCardModel getResponse(Integer code,String msg) {
        ResponseOpenCardModel responseOpenCardModel = getResponse();
        responseOpenCardModel.setCode(code);
        responseOpenCardModel.setMessage(msg);
        return responseOpenCardModel;
    }

    public static ResponseOpenCardModel getResponse(Integer code) {
        ResponseOpenCardModel responseOpenCardModel = getResponse();
        responseOpenCardModel.setCode(code);
        responseOpenCardModel.setMessage("响应");
        return responseOpenCardModel;
    }
}
