package com.bizvane.members.facade.service.datafetch.model;

import lombok.*;

import java.io.Serializable;

/**
 * Created by xz on 2019/10/24.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class MemberOrderPayMentFetchModel  extends BaseFetchModel implements Serializable {
    /**
     * 企业code
     */
    private String offlineCompanyCode;

    /**
     *  品牌code
     */
    private String brandCode;

    /**
     *  关联的订单号
     */
    private String orderNo;

    /**
     *  支付金额
     */
    private String  payAmount;

    /**
     *  支付类型/方式代码
     */
    private String  payType;

    /**
     *  支付类型/方式名称
     */
    private String  payName;

    /**
     *  支付流水单号
     */
    private String  payNumber;

    /**
     *  使用积分
     */
    private Integer  integralUsed;

    /**
     *  积分类型 0减积分 1加积分
     */
    private Integer  integralType;

    /**
     *  支付使用的优惠券号
     */
    private String  couponCode;

    /**
     *  0-表示减积分 1-表示加积分，默认0
     */
    private Integer  opsIntegral;
}
