package com.bizvane.members.facade.enums;

public enum StaffHandleEnum {

    DISMISSION(1, "离职"),

    ADJUST(2, "调店");

    private Integer code;

    private String msg;

    StaffHandleEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (StaffHandleEnum type : StaffHandleEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }

}
