package com.bizvane.members.facade.service.datafetch.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/8/10 10:57
 * @Description:积分记录取数对象
 */
@Data
public class IntegralRecordFetchModel extends BaseFetchModel implements Serializable {

    private static final long serialVersionUID = 2003449119231835981L;

    //private String integralCode; //积分流水号

    private String changeBills; //变更单据

    private Integer changeIntegral; //变更积分

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date changeDate; //变动时间

    private String changeWay; //变动类型1.支出,2.收入,3过期4.清零

    private String changeDetails; //变更详情

    private String businessWay; //业务类型:详见枚举类

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveTime; //积分有效时间

    private String remark; //备注

    private String offlineIntegralId;//线下积分流水id


}
