package com.bizvane.members.facade.models;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 更新会员资料接口入参model
 * </p>
 * @author dingShiChen
 * @since 2019/10/15
 */
@Data
public class MemberInfoUpdateRequestVO {

	/*
		企业id
	 */
	@NotNull
	private Long sysCompanyId;

	/*
		品牌id
	 */
	@NotNull
	private Long sysBrandId;

	/*
		来源，请求来源:1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他（如果是1，不掉icrm，如果不是1，调icrm传999）
	 */
	@NotEmpty
	private String source;

	/*
		会员原始手机号
	 */
	@NotEmpty
	private String phone;

	/*
		线下品牌code
	 */
	private String offlineBrandCode;

	/*
		会员卡号
	 */
	@NotEmpty
	private String cardNo;

	/*
		会员姓名
	 */
	private String newName;

	/*
		会员手机号
	 */
	private String newPhone;

	/*
		会员性别（1女、2男、3，未知，默认未知）
	 */
	private String newSex;

	/*
		省
	 */
	private String newProvince;

	/*
		市
	 */
	private String newCity;

	/*
		区
	 */
	private String newCounty;

	/*
		会员详细地址
	 */
	private String newAddress;

	/*
		备注
	 */
	private String newRemark;

	/*
		会员邮箱
	 */
	private String newEmail;

	/*
		会员身份证号
	 */
	private String newIdCard;

	/*
		会员生日 格式：yyyy-MM-dd
	 */
	private Date newBirthday;

	/*
		等级code
	 */
	private String newLevelCode;

	/*
		亲属关系
	 */
	private List<UpdateMemberRelativeRequestVO> relations;
}
