package com.bizvane.members.facade.service.standard;

import com.bizvane.members.facade.vo.OpenApiOpenCardRequestVo;
import com.bizvane.members.facade.vo.OpenApiOpenCardResponseVo;
import com.bizvane.members.facade.vo.StandardOpenCardRequestVo;
import com.bizvane.members.facade.vo.StandardOpenCardResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
@RequestMapping(value = "/api/openApi")
public interface OpenApiOpenCardService {

    @RequestMapping(value = "/openCard", method = RequestMethod.POST)
    ResponseData<OpenApiOpenCardResponseVo> openCard(@RequestBody @Valid OpenApiOpenCardRequestVo openApiOpenCardRequestVo);

}
