package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.SkuSalesDetailRequestVo;
import com.bizvane.members.facade.vo.SkuSalesDetailVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderEvaluateModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.vo.OrderApiVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/8/3 15:19
 * @Description:
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberOrderApiService {
    /**
     * 查询会员订单列表
     *
     * @param orderModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberOrder/queryOrderList", method = RequestMethod.POST)
    ResponseData<PageInfo<OrderModel>> queryOrderList(@RequestBody OrderApiVo OrderApiVo) throws MemberException;

    /**
     * 查询订单详情
     *
     * @param orderModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberOrder/queryOrderInfo", method = RequestMethod.POST)
    ResponseData<OrderModel> queryOrderInfo(@RequestBody OrderModel orderModel) throws MemberException;

    /**
     * 评价订单
     *
     * @param orderEvaluateModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberOrder/addOrderEvaluate", method = RequestMethod.POST)
    ResponseData addOrderEvaluate(@RequestBody OrderEvaluateModel orderEvaluateModel) throws MemberException;

    /**
     * 查询订单评价详情
     *
     * @param orderNo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberOrder/queryOrderEvaluateInfo", method = RequestMethod.POST)
    ResponseData<OrderEvaluateModel> queryOrderEvaluateInfo(@RequestParam("orderNo") String orderNo) throws MemberException;

    /**
     * 上传订单评价图片
     *
     * @param currentMember
     * @return
     */
    @RequestMapping(value = "/api/memberOrder/uploadEvaluatePic", method = RequestMethod.POST)
    ResponseData<JSONObject> uploadEvaluatePic(@RequestBody MemberInfoModel currentMember) throws MemberException;

    /**
     * 查询订单商品编号
     *
     * @param orderNo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/memberOrder/queryOrderProductNo", method = RequestMethod.POST)
    ResponseData<String> queryOrderProductNo(@RequestParam("orderNo") String orderNo) throws MemberException;


    @RequestMapping(value = "/api/memberOrder/queryOrderModel", method = RequestMethod.POST)
    ResponseData<OrderModel> queryOrderModel(@RequestParam("orderNo") String orderNo, @RequestParam("brandId") Long brandId);

    /**
     * 根据店铺id或导购id 和时间 查询订单
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/memberOrder/queryOrderModelByStore", method = RequestMethod.POST)
    ResponseData<SkuSalesDetailVo> queryOrderModelByStore(OrderModel vo,Integer pageNumber,Integer pageSize);
}
