package com.bizvane.members.facade.vo.vg;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class VGMemberLevelChangeVo {

    @NotNull(message = "sysCompanyId不能为空")
    private Long sysCompanyId;

    @NotEmpty(message = "brandCode必须填")
    private String brandCode;

    @NotEmpty(message = "会员卡号必须填")
    private String cardNo;

    @NotEmpty(message = "会员变更前等级必须填")
    private String oldLevelCode;

    @NotEmpty(message = "会员变更后等级必须填")
    private String newLevelCode;

    private String detail;
}